<?php
session_start();
include 'db_connection.php'; // فایل پیکربندی دیتابیس

// فرض می‌کنیم که user_id کاربر لاگین شده در سشن ذخیره شده است
$logged_in_user_id = $_SESSION['user_id'];

if (!$logged_in_user_id) {
    die('شما باید وارد سیستم شوید.');
}

// ایجاد ارتباط با دیتابیس
$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("اتصال به دیتابیس با خطا مواجه شد: " . $conn->connect_error);
}

// خواندن رکوردهای مرتبط با کاربر لاگین شده
$sql = "SELECT id, first_name, last_name, national_id, stage_name FROM arazi_file WHERE assigned_to = ?";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    die("خطا در آماده‌سازی کوئری: " . $conn->error);
}

$stmt->bind_param("i", $logged_in_user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($conn->error) {
    die("خطا در اجرای کوئری: " . $conn->error);
}

?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>اینبا‌کس اراضی</title>
    <link rel="stylesheet" type="text/css" href="table.css">
</head>
<body>
    <h2>اینبا‌کس اراضی</h2>
    <table>
        <tr>
            <th>شناسه</th>
            <th>نام</th>
            <th>نام خانوادگی</th>
            <th>کد ملی</th>
            <th>نام مرحله</th>
        </tr>
        <?php while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?php echo $row['id']; ?></td>
                <td><?php echo $row['first_name']; ?></td>
                <td><?php echo $row['last_name']; ?></td>
                <td><?php echo $row['national_id']; ?></td>
                <td><?php echo $row['stage_name']; ?></td>
            </tr>
        <?php endwhile; ?>
    </table>
    <?php
    // بستن ارتباط با دیتابیس
    $stmt->close();
    $conn->close();
    ?>
</body>
</html>
