<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لیست کلی پرونده‌ها</title>
    <link rel="stylesheet" href="table.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</head>
<body>
    <h2>لیست کلی پرونده‌ها</h2>
    <input type="text" id="searchInput" placeholder="جستجو...">
    <div id="filesList">
        <?php
        require_once "db_connection.php";

        $sql = "SELECT * FROM files";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            echo "<table>";
            echo "<thead><tr><th>فایل آیدی</th><th>نام</th><th>نام خانوادگی</th><th>کد ملی</th><th>وضعیت پرونده</th></tr></thead>";
            echo "<tbody>";
            while ($row = $result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . $row['file_id'] . "</td>";
                echo "<td>" . $row['operator_first_name'] . "</td>";
                echo "<td>" . $row['operator_last_name'] . "</td>";
                echo "<td>" . $row['national_code'] . "</td>";
                echo "<td>" . $row['status'] . "</td>";
                echo "</tr>";
            }
            echo "</tbody></table>";
        } else {
            echo "هیچ پرونده‌ای یافت نشد.";
        }
        $conn->close();
        ?>
    </div>
    <script>
        $(document).ready(function(){
            $("#searchInput").on("keyup", function() {
                var value = $(this).val().toLowerCase();
                $("#filesList table tbody tr").filter(function() {
                    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                });
            });
        });
    </script>
    <footer>
        <a href="user_dashboard.php">بازگشت به داشبورد</a>
        <a href="logout.php">خروج</a>
    </footer>
</body>
</html>
