<?php
session_start();
include 'db_connection.php';

if (isset($_SESSION['username'])) {
    $username = $_SESSION['username'];
    
    // Query to get user_id from users table
    $sql = "SELECT user_id FROM users WHERE username = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->bind_result($user_id);
    
    if ($stmt->fetch()) {
        // Store user_id in session
        $_SESSION['user_id'] = $user_id;
    } else {
        echo "User not found.";
    }
    
    $stmt->close();
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>داشبورد مسئول بایگانی</title>
<link rel="stylesheet" href="archive_manager_styles.css">
</head>
<body>
<div class="container">
  <header>
    <h2>داشبورد مسئول بایگانی</h2>
    <div class="user-info">
      <?php 
      if(isset($_SESSION['username'])) {
        echo "<p>نام کاربر: " . $_SESSION['username'] . "</p>"; 
      } else {
        echo "<p>نام کاربر: نامعلوم</p>"; // یا هر پیام دیگری که مد نظر شما باشد
      }
      ?>
    </div>
  </header>
  <nav>
    <ul>
      <li><a href="add_file.php">ثبت پرونده جدید</a></li>
      <li><a href="sus_list.php">پرونده های معلق</a></li>
      <li><a href="all_files.php">مشاهده پرونده‌ها</a></li>
      <li><a href="#">صندوق درخواست‌ها</a></li>
      <li><a href="#">ارجاع موردی</a></li>
    </ul>
  </nav>
  <main>
    <!-- محتوای اصلی داشبورد -->
  </main>
  <footer>
    <form action="logout.php" method="post">
      <button type="submit">خروج</button>
    </form>
  </footer>
</div>
</body>
</html>
