<?php
require 'db_connection.php'; // اتصال به پایگاه داده

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // دریافت ورودی از فرم
    $full_name = $_POST['full_name'];

    // اجرای کوئری جستجو در ۷ جدول با استفاده از UNION
    $sql = "
        SELECT id, name, request_type, city FROM mtoyur WHERE name LIKE ?
        UNION
        SELECT id, name, request_type, city FROM mgolkhaneh WHERE name LIKE ?
        UNION
        SELECT id, name, request_type, city FROM mdamsb WHERE name LIKE ?
        UNION
        SELECT id, name, request_type, city FROM mdamsa WHERE name LIKE ?
        UNION
        SELECT id, name, request_type, city FROM mgiah WHERE name LIKE ?
        UNION
        SELECT id, name, request_type, city FROM mshilat WHERE name LIKE ?
        UNION
        SELECT id, name, request_type, city FROM mgheir WHERE name LIKE ?
    ";
    
    $stmt = $conn->prepare($sql);
    $likeName = "%$full_name%";
    
    // بایند کردن پارامترها برای 7 جدول
    $stmt->bind_param('sssssss', $likeName, $likeName, $likeName, $likeName, $likeName, $likeName, $likeName);
    
    $stmt->execute();
    $result = $stmt->get_result();

    // بررسی وجود نتایج
    if ($result->num_rows > 0) {
        $results = $result->fetch_all(MYSQLI_ASSOC);
    } else {
        $results = [];
    }

    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>فرم جستجو</title>
    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            direction: rtl;
        }
        .container {
            text-align: right;
        }
        .form-label {
            float: right;
        }
        .table th, .table td {
            text-align: right;
        }
        .btn-group {
            display: flex;
            justify-content: space-between;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2 class="text-center">جستجوی اطلاعات پرونده</h2>
        <form action="dabirkhaneh.php" method="post" class="mt-4">
            <div class="mb-3">
                <label for="full_name" class="form-label">نام کامل (نام و نام خانوادگی)</label>
                <input type="text" class="form-control" id="full_name" name="full_name" required>
            </div>
            <div class="btn-group">
                <button type="submit" class="btn btn-primary">جستجو</button>
                <a href="baygani.html" class="btn btn-success">اضافه کردن پرونده</a>
            </div>
        </form>
        
        <!-- نمایش نتیجه جستجو -->
        <div id="result" class="mt-4">
            <?php if (isset($results) && !empty($results)) : ?>
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>شماره پرونده</th>
                            <th>نام و نام خانوادگی</th>
                            <th>نوع درخواست</th>
                            <th>نام شهرستان</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($results as $result): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($result['id']); ?></td>
                                <td><?php echo htmlspecialchars($result['name']); ?></td>
                                <td><?php echo htmlspecialchars($result['request_type']); ?></td>
                                <td><?php echo htmlspecialchars($result['city']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php elseif ($_SERVER['REQUEST_METHOD'] == 'POST') : ?>
                <p class="text-danger">هیچ نتیجه‌ای یافت نشد.</p>
            <?php endif; ?>
        </div>
    </div>

    <script src="bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>