<?php
// شامل فایل اتصال به دیتابیس
include 'db_connection.php';

// دریافت اطلاعات از جدول files
$sql = "SELECT * FROM files";
$result = $conn->query($sql);

?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>مدیریت فایل‌ها</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/css/bootstrap-rtl.min.css" rel="stylesheet">
    <style>
        body {
            direction: rtl;
            text-align: right;
            background-color: #f8f9fa;
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .container-fluid {
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        .table-responsive {
            flex: 1;
            overflow: auto;
        }
        th, td {
            vertical-align: middle !important;
        }
        .form-control-plaintext {
            background-color: transparent !important;
            border: none !important;
        }
        .table thead th {
            white-space: nowrap;
        }
        .table tbody td {
            white-space: nowrap;
        }
        .small-col {
            width: 50px;
        }
        .smaller-col {
            width: 120px;
        }
        .filter-row {
            background-color: #f8f9fa;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <h1 class="my-4 text-center">مدیریت فایل‌ها</h1>
        <div id="alert" class="alert" style="display: none;"></div>
        <div class="mb-3">
            <input type="text" id="searchInput" class="form-control" placeholder="جستجو...">
        </div>
        <div class="mb-3 text-left">
            <a href="export_excel.php" class="btn btn-success">دانلود اکسل</a>
        </div>
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="filesTable">
                <thead class="thead-dark">
                    <tr>
                        <th class="small-col">ردیف</th>
                        <th>نام اپراتور</th>
                        <th>نام خانوادگی اپراتور</th>
                        <th>کد ملی</th>
                        <th>شماره تلفن</th>
                        <th>کلاس فایل</th>
                        <th>
                            <select id="requestTypeFilter" class="form-control">
                                <option value="">نوع درخواست</option>
                                <!-- گزینه‌ها به صورت پویا اضافه می‌شوند -->
                            </select>
                        </th>
                        <th class="smaller-col">شناسه مرحله</th>
                        <th>
                            <select id="stageNameFilter" class="form-control">
                                <option value="">نام مرحله</option>
                                <!-- گزینه‌ها به صورت پویا اضافه می‌شوند -->
                            </select>
                        </th>
                        <th class="smaller-col">واگذار شده به</th>
                        <th>زمان شروع مرحله</th>
                        <th>
                            <select id="statusFilter" class="form-control">
                                <option value="">وضعیت</option>
                                <!-- گزینه‌ها به صورت پویا اضافه می‌شوند -->
                            </select>
                        </th>
                        <th>عملیات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if ($result->num_rows > 0) {
                        $row_num = 1;
                        $requestTypes = [];
                        $stageNames = [];
                        $statuses = [];
                        while($row = $result->fetch_assoc()) {
                            // جمع‌آوری نوع درخواست، نام مرحله و وضعیت برای فیلترها
                            if (!in_array($row["request_type"], $requestTypes)) {
                                $requestTypes[] = $row["request_type"];
                            }
                            if (!in_array($row["stage_name"], $stageNames)) {
                                $stageNames[] = $row["stage_name"];
                            }
                            if (!in_array($row["status"], $statuses)) {
                                $statuses[] = $row["status"];
                            }
                            echo "<tr>
                                    <form class='updateForm'>
                                        <td class='align-middle small-col'>$row_num</td>
                                        <td><input type='hidden' name='file_id' value='".$row["file_id"]."'><input type='text' name='operator_first_name' value='".$row["operator_first_name"]."' class='form-control'></td>
                                        <td><input type='text' name='operator_last_name' value='".$row["operator_last_name"]."' class='form-control'></td>
                                        <td><input type='text' name='national_code' value='".$row["national_code"]."' class='form-control'></td>
                                        <td><input type='text' name='phone_number' value='".$row["phone_number"]."' class='form-control'></td>
                                        <td><input type='text' name='file_class' value='".$row["file_class"]."' class='form-control'></td>
                                        <td><input type='text' name='request_type' value='".$row["request_type"]."' class='form-control request-type'></td>
                                        <td class='smaller-col'><input type='text' name='stage_id' value='".$row["stage_id"]."' class='form-control'></td>
                                        <td><input type='text' name='stage_name' value='".$row["stage_name"]."' class='form-control stage-name'></td>
                                        <td class='smaller-col'><input type='text' name='assigned_to' value='".$row["assigned```php
_to"]."' class='form-control'></td>
                                        <td><input type='text' name='stage_start_time' value='".$row["stage_start_time"]."' class='form-control'></td>
                                        <td><input type='text' name='status' value='".$row["status"]."' class='form-control status'></td>
                                        <td><button type='submit' class='btn btn-primary'>به‌روزرسانی</button></td>
                                    </form>
                                </tr>";
                            $row_num++;
                        }
                    } else {
                        echo "<tr><td colspan='13' class='text-center'>هیچ داده‌ای موجود نیست</td></tr>";
                    }
                    $conn->close();
                    ?>
                </tbody>
            </table>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            var requestTypes = <?php echo json_encode($requestTypes); ?>;
            var stageNames = <?php echo json_encode($stageNames); ?>;
            var statuses = <?php echo json_encode($statuses); ?>;

            var requestTypeFilter = $('#requestTypeFilter');
            var stageNameFilter = $('#stageNameFilter');
            var statusFilter = $('#statusFilter');

            requestTypes.forEach(function(type) {
                requestTypeFilter.append(new Option(type, type));
            });

            stageNames.forEach(function(name) {
                stageNameFilter.append(new Option(name, name));
            });

            statuses.forEach(function(status) {
                statusFilter.append(new Option(status, status));
            });

            // فیلتر کردن جدول
            function filterTable() {
                var requestType = $('#requestTypeFilter').val().toLowerCase();
                var stageName = $('#stageNameFilter').val().toLowerCase();
                var status = $('#statusFilter').val().toLowerCase();
                var searchInput = $('#searchInput').val().toLowerCase();

                $('#filesTable tbody tr').filter(function() {
                    $(this).toggle(
                        $(this).find('.request-type').val().toLowerCase().indexOf(requestType) > -1 &&
                        $(this).find('.stage-name').val().toLowerCase().indexOf(stageName) > -1 &&
                        $(this).find('.status').val().toLowerCase().indexOf(status) > -1 &&
                        $(this).text().toLowerCase().indexOf(searchInput) > -1
                    );
                });
            }

            $('#requestTypeFilter, #stageNameFilter, #statusFilter, #searchInput').on('input change', filterTable);

            // استفاده از AJAX برای به‌روزرسانی داده‌ها
            $('.updateForm').on('submit', function(event) {
                event.preventDefault(); // جلوگیری از ارسال فرم به روش پیش‌فرض

                var $form = $(this);
                var serializedData = $form.serialize();

                $.ajax({
                    url: 'update.php',
                    type: 'POST',
                    data: serializedData,
                    success: function(response) {
                        var jsonResponse = JSON.parse(response);

                        // نمایش پیام موفقیت یا خطا
                        var $alert = $('#alert');
                        $alert.removeClass('alert-success alert-danger');
                        if (jsonResponse.status === 'success') {
                            $alert.addClass('alert-success');
                        } else {
                            $alert.addClass('alert-danger');
                        }
                        $alert.text(jsonResponse.message).show();

                        // مخفی کردن پیام پس از چند ثانیه
                        setTimeout(function() {
                            $alert.fadeOut();
                        }, 3000);
                    }
                });
            });
        });
    </script>
</body>
</html>
