<?php
require_once "db_connection.php";

if (!isset($_GET['id']) || !isset($_GET['step'])) {
    die("پارامتر ناقص است.");
}

$id = (int)$_GET['id'];
$step = (int)$_GET['step'];

if ($step < 1 || $step > 10) {
    die("مرحله نامعتبر است.");
}

$query = $conn->prepare("SELECT * FROM karshenasan WHERE id = ?");
$query->bind_param("i", $id);
$query->execute();
$result = $query->get_result();
if ($result->num_rows === 0) {
    die("پرونده یافت نشد.");
}
$row = $result->fetch_assoc();

$kmlPath = $row['kml_path'] ?? '';
if (empty($kmlPath) || !file_exists($kmlPath)) {
    die("فایل KML اصلی موجود نیست.");
}

$jalaliDate = $row["date$step"];
if (empty($jalaliDate)) {
    die("تاریخ این مرحله ثبت نشده است.");
}

// تبدیل تاریخ شمسی به میلادی
function jalaliToGregorian($jy, $jm, $jd) {
    $jy += 1595;
    $days = -355668 + (365 * $jy) + (intdiv($jy, 33) * 8) + intdiv(($jy % 33) + 3, 4) + $jd + (($jm < 7) ? ($jm - 1) * 31 : (($jm - 7) * 30) + 186);
    $gy = 400 * intdiv($days, 146097);
    $days %= 146097;
    if ($days > 36524) {
        $gy += 100 * intdiv(--$days, 36524);
        $days %= 36524;
        if ($days >= 365) $days++;
    }
    $gy += 4 * intdiv($days, 1461);
    $days %= 1461;
    if ($days > 365) {
        $gy += intdiv($days - 1, 365);
        $days = ($days - 1) % 365;
    }
    $gd = $days + 1;
    $sal_a = [0, 31, (($gy % 4 == 0 && $gy % 100 != 0) || ($gy % 400 == 0)) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    for ($gm = 0; $gm < 13; $gm++) {
        if ($gd <= $sal_a[$gm]) break;
        $gd -= $sal_a[$gm];
    }
    return sprintf('%04d-%02d-%02d', $gy, $gm, $gd);
}

function convertJalaliToGregorian($jalaliDate) {
    list($jy, $jm, $jd) = explode('-', $jalaliDate);
    return jalaliToGregorian((int)$jy, (int)$jm, (int)$jd);
}

$timestamp = convertJalaliToGregorian($jalaliDate) . "T00:00:00Z";

// خواندن فایل اصلی KML
$kmlContent = file_get_contents($kmlPath);

// اگر <TimeStamp> وجود ندارد، اضافه کن
if (strpos($kmlContent, '<TimeStamp>') === false) {
    // فرض بر اینکه فایل شامل <Placemark> هست و ما باید تایم‌استمپ داخلش قرار بدیم
    $kmlContent = preg_replace(
        '/<Placemark([^>]*)>/',
        "<Placemark$1>\n<TimeStamp><when>$timestamp</when></TimeStamp>",
        $kmlContent,
        1
    );
} else {
    // در غیر اینصورت مقدار <when> را به‌روزرسانی کن
    $kmlContent = preg_replace(
        '/<TimeStamp>.*?<when>.*?<\/when>.*?<\/TimeStamp>/s',
        "<TimeStamp><when>$timestamp</when></TimeStamp>",
        $kmlContent
    );
}

// ارسال فایل برای دانلود
header('Content-Type: application/vnd.google-earth.kml+xml');
header("Content-Disposition: attachment; filename=case_{$id}_step_{$step}.kml");
echo $kmlContent;
exit;
