<?php
session_start();
require_once "db_connection.php";

// بررسی ورود کاربر
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// اتصال به دیتابیس
$conn = new mysqli($servername, $username, $password, $dbname);

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// بازیابی اطلاعات کاربر
$user_id = $_SESSION['user_id'];

// بازیابی نام و نام خانوادگی کاربر و نقش
$user_sql = "SELECT CONCAT(first_name, ' ', last_name) AS full_name, role FROM users WHERE user_id = ?";
$stmt = $conn->prepare($user_sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user_result = $stmt->get_result();
$user = $user_result->fetch_assoc();
$stmt->close();

if (!$user) {
    die("User not found.");
}

$full_name = $user['full_name'];
$role = $user['role'];

// بازیابی اطلاعات کاربران با نقش 'normal' و 'admin'
$users = [];
$user_sql = "SELECT user_id, CONCAT(first_name, ' ', last_name) AS name FROM users WHERE role IN ('normal', 'admin')";
$user_result = $conn->query($user_sql);

if ($user_result === false) {
    die("Error executing query: " . $conn->error);
}

if ($user_result->num_rows > 0) {
    while ($row = $user_result->fetch_assoc()) {
        $users[] = $row;
    }
}

// پردازش پاسخ‌های ارسال شده
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id']) && isset($_POST['response']) && isset($_POST['assignee_id'])) {
    $letter_id = $_POST['id'];
    $response = $_POST['response'];
    $assignee_id = $_POST['assignee_id'];
    
    // بررسی ستون‌های نال و تنظیم کوئری بر اساس آن‌ها
    $col_names = ['reply', 'reply_1', 'reply_2', 'reply_3', 'reply_4'];
    $user_col_names = ['reply_user', 'reply_user_1', 'reply_user_2', 'reply_user_3', 'reply_user_4'];
    $col_to_update = null;
    $user_col_to_update = null;

    // بازیابی اطلاعات نامه برای بررسی ستون‌های نال
    $letter_sql = "SELECT " . implode(", ", array_merge($col_names, $user_col_names)) . " FROM letters WHERE id = ?";
    $stmt = $conn->prepare($letter_sql);
    $stmt->bind_param("i", $letter_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $letter = $result->fetch_assoc();
    $stmt->close();

    // پیدا کردن اولین ستون نال
    foreach ($col_names as $index => $col) {
        if (is_null($letter[$col])) {
            $col_to_update = $col;
            $user_col_to_update = $user_col_names[$index];
            break;
        }
    }

    if ($col_to_update && $user_col_to_update) {
        $update_sql = "UPDATE letters SET $col_to_update = ?, $user_col_to_update = ?, reply_status = 'پاسخ داده شده', assignee_id = ? WHERE id = ?";
        $stmt = $conn->prepare($update_sql);
        $stmt->bind_param("ssii", $response, $full_name, $assignee_id, $letter_id);
        
        if ($stmt->execute()) {
            echo "پاسخ شما با موفقیت ثبت شد.";
        } else {
            echo "خطایی در ثبت پاسخ رخ داد: " . $stmt->error;
        }
        
        $stmt->close();
    } else {
        echo "همه ستون‌های پاسخ پر هستند.";
    }
}

// پردازش دکمه خاتمه یافته
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['end_letter_id'])) {
    $letter_id = $_POST['end_letter_id'];
    
    $end_sql = "UPDATE letters SET reply_status = 'خاتمه یافته' WHERE id = ?";
    $stmt = $conn->prepare($end_sql);
    $stmt->bind_param("i", $letter_id);
    
    if ($stmt->execute()) {
        echo "وضعیت نامه به 'خاتمه یافته' تغییر یافت.";
    } else {
        echo "خطایی در تغییر وضعیت نامه رخ داد: " . $stmt->error;
    }
    
    $stmt->close();
}

// کوئری برای بازیابی نامه‌های مهم کاربر با وضعیت 'پاسخ داده شده' یا NULL
$sql = "SELECT id, subject, description, end_date, reply, reply_user, reply_1, reply_user_1, reply_2, reply_user_2, reply_3, reply_user_3, reply_4, reply_user_4, attachment_path 
        FROM letters 
        WHERE assignee_id='$user_id' AND (reply_status = 'پاسخ داده شده' OR reply_status IS NULL)";
$result = $conn->query($sql);

if ($result === false) {
    die("Error executing query: " . $conn->error);
}
?>


<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>نامه‌های مهم</title>
<link rel="stylesheet" href="table.css">
<style>
/* اضافه کردن استایل برای عریض کردن ستون توضیحات */
.table-description {
    width: 300px; /* تنظیم عرض دلخواه */
}
</style>
<script>
// تابع برای نمایش زمان باقی‌مانده به صورت تایمر
function showRemainingTime(endTime) {
    var now = new Date();
    var end = new Date(endTime);
    var remaining = end - now;

    var days = Math.floor(remaining / (1000 * 60 * 60 * 24));
    var hours = Math.floor((remaining % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    var minutes = Math.floor((remaining % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = Math.floor((remaining % (1000 * 60)) / 1000);

    return days + " روز و " + hours + " ساعت و " + minutes + " دقیقه و " + seconds + " ثانیه";
}

// تابع برای نمایش تمامی پاسخ‌ها
function showAllReplies(letterId) {
    var repliesRow = document.getElementById("replies-row-" + letterId);
    if (repliesRow.style.display === "none") {
        repliesRow.style.display = "table-row";
    } else {
        repliesRow.style.display = "none";
    }
}
</script>
</head>
<body>
<div class="container">
  <header>
    <h2>نامه‌های مهم</h2>
  </header>
  <main>
    <?php
    if ($result->num_rows > 0) {
        // چاپ جدول نامه‌های مهم
        echo "<table>";
        echo "<tr><th>عنوان نامه</th><th class='table-description'>توضیحات</th><th>زمان باقی‌مانده</th><th>ارجاع گیرنده</th><th>ثبت پاسخ</th><th>پیوست</th><th>عملیات</th>";
        if ($role === 'admin') {
            echo "<th>عملیات ویژه</th>";
        }
        echo "</tr>";
        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($row["subject"]) . "</td>";
            echo "<td class='table-description'>" . htmlspecialchars($row["description"]) . "</td>";
            echo "<td><script>document.write(showRemainingTime('" . htmlspecialchars($row["end_date"]) . "'))</script></td>";
            echo "<td>";
            echo "<form method='post' action=''>";
            echo "<input type='hidden' name='id' value='" . htmlspecialchars($row["id"]) . "'>";
            echo "<select name='assignee_id'>";
            if (count($users) > 0) {
                foreach ($users as $user) {
                    echo "<option value='" . htmlspecialchars($user['user_id']) . "'>" . htmlspecialchars($user['name']) . "</option>";
                }
            } else {
                echo "<option value=''>هیچ کاربری یافت نشد</option>";
            }
            echo "</select>";
            echo "</td>";
            echo "<td>";
            echo "<textarea name='response' placeholder='پاسخ خود را وارد کنید'></textarea>";
            echo "<button type='submit'>ثبت پاسخ</button>";
            echo "</form>";
            echo "</td>";
            echo "<td>";
            if (!empty($row["attachment_path"])) {
                echo "<a href='" . htmlspecialchars($row["attachment_path"]) . "' download>دانلود پیوست</a>";
            } else {
                echo "بدون پیوست";
            }
            echo "</td>";
            echo "<td>";
            echo "<button onclick='showAllReplies(" . htmlspecialchars($row["id"]) . ")'>مشاهده همه پاسخ‌ها</button>";
            echo "</td>";
            if ($role === 'admin') {
                echo "<td>";
                echo "<form method='post' action=''>";
                echo "<input type='hidden' name='end_letter_id' value='" . htmlspecialchars($row["id"]) . "'>";
                echo "<button type='submit'>خاتمه یافته</button>";
                echo "</form>";
                echo "</td>";
            }
            echo "</tr>";
            echo "<tr id='replies-row-" . htmlspecialchars($row["id"]) . "' style='display:none;'><td colspan='" . ($role === 'admin' ? "8" : "7") . "'>";
            for ($i = 0; $i <= 4; $i++) {
                $reply_col = $i == 0 ? "reply" : "reply_$i";
                $reply_user_col = $i == 0 ? "reply_user" : "reply_user_$i";
                if (!is_null($row[$reply_col])) {
                    echo htmlspecialchars($row[$reply_col]) . " (" . htmlspecialchars($row[$reply_user_col]) . ")<br>";
                }
            }
            echo "</td></tr>";
        }
        echo "</table>";
    } else {
        echo "نامه‌ای یافت نشد.";
    }
    ?>
  </main>
  <footer>
    <a href="user_dashboard.php">بازگشت به صفحه اصلی</a>
  </footer>
</div>
</body>
</html>
