<?php
session_start();
require_once "db_connection.php";

// چک کردن ورود کاربر
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// اتصال به دیتابیس و بازیابی اطلاعات کاربر
$servername = "localhost";
$username = "anreoalb_archive";
$password = "Shahrooz@2681";
$dbname = "anreoalb_archive";

// اتصال به دیتابیس
$conn = new mysqli($servername, $username, $password, $dbname);

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// بررسی درخواست POST برای خاتمه دادن به نامه
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['finish_letter_id'])) {
    $letter_id = intval($_POST['finish_letter_id']);
    $sql_update = "UPDATE letters SET reply_status='خاتمه یافته' WHERE id=?";
    $stmt = $conn->prepare($sql_update);
    $stmt->bind_param("i", $letter_id);
    if ($stmt->execute()) {
        echo "نامه با موفقیت خاتمه یافت.";
    } else {
        echo "خطا در خاتمه نامه: " . $stmt->error;
    }
    $stmt->close();
}

// کوئری برای بازیابی نامه‌های پاسخ داده شده
$sql = "SELECT id, subject, description, end_date, reply FROM letters WHERE reply_status='پاسخ داده شده'";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پاسخ نامه‌های مهم</title>
    <link rel="stylesheet" href="table.css">
</head>
<body>
<div class="container">
    <header>
        <h2>پاسخ نامه‌های مهم</h2>
    </header>
    <main>
        <?php
        if ($result->num_rows > 0) {
            echo "<table>";
            echo "<tr><th>عنوان نامه</th><th>توضیحات</th><th>زمان باقی‌مانده</th><th>پاسخ</th><th>عملیات</th></tr>";
            while ($row = $result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>" . htmlspecialchars($row["subject"]) . "</td>";
                echo "<td>" . htmlspecialchars($row["description"]) . "</td>";
                echo "<td>" . htmlspecialchars($row["end_date"]) . "</td>";
                echo "<td>" . htmlspecialchars($row["reply"]) . "</td>";
                echo "<td>
                        <form method='post' action=''>
                            <input type='hidden' name='finish_letter_id' value='" . $row["id"] . "'>
                            <button type='submit'>خاتمه</button>
                        </form>
                      </td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "هیچ نامه پاسخ داده شده‌ای یافت نشد.";
        }
        ?>
    </main>
    <footer>
        <a href="admin_dashboard.php">بازگشت به صفحه اصلی</a>
    </footer>
</div>
</body>
</html>

<?php
$conn->close();
?>
