<?php
session_start();
require_once "db_connection.php";

// چک کردن ورود کاربر
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// اتصال به دیتابیس و بازیابی اطلاعات کاربر
$servername = "localhost";
$username = "anreoalb_archive";
$password = "Shahrooz@2681";
$dbname = "anreoalb_archive";

// اتصال به دیتابیس
$conn = new mysqli($servername, $username, $password, $dbname);

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// بازیابی شناسه کاربر از جلسه
$user_id = $_SESSION['user_id'];

// بازیابی نام و نام خانوادگی کاربر
$user_query = "SELECT first_name, last_name FROM users WHERE user_id = ?";
$stmt = $conn->prepare($user_query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user_result = $stmt->get_result();
$user_row = $user_result->fetch_assoc();
$user_first_name = $user_row['first_name'];
$user_last_name = $user_row['last_name'];

// دریافت پرونده‌هایی که به کاربر فعلی ارجاع داده شده‌اند
$query = "
SELECT f.file_id, f.operator_first_name, f.operator_last_name, f.national_code, f.request_type, f.stage_name, 
       CASE 
           WHEN f.request_type = 'تمدید تاسیس گلخانه' THEN tt.allowed_time
           WHEN f.request_type = 'تمدید بهره برداری دام/طیور/شیلات' THEN tb.allowed_time
           WHEN f.request_type = 'تغییر نام گلخانه' THEN tn.allowed_time
           WHEN f.request_type = 'بهسازی و نوسازی گلخانه' THEN bn.allowed_time
           WHEN f.request_type = 'تغییر کشت' THEN tk.allowed_time
           WHEN f.request_type = 'صدور بهره برداری گلخانه' THEN b.allowed_time
           WHEN f.request_type = 'اصلاح بهره برداری گلخانه' THEN eb.allowed_time
           WHEN f.request_type = 'تمدید توسعه گلخانه' THEN tt2.allowed_time
           WHEN f.request_type = 'تمدید بهره برداری گلخانه' THEN b2.allowed_time
           WHEN f.request_type = 'اصلاح تاسیس گلخانه' THEN et.allowed_time
           WHEN f.request_type = 'تمدید تاسیس قارچ' THEN ttgh.allowed_time
           WHEN f.request_type = 'تمدید توسعه قارچ' THEN ttgh.allowed_time
           ELSE s.allowed_time
       END AS allowed_time, 
       f.stage_start_time, 
       CASE 
           WHEN f.request_type = 'تمدید تاسیس گلخانه' THEN tt.stage_id + 1
           WHEN f.request_type = 'تمدید بهره برداری دام/طیور/شیلات' THEN tb.stage_id + 1
           WHEN f.request_type = 'تغییر نام گلخانه' THEN tn.stage_id + 1
           WHEN f.request_type = 'بهسازی و نوسازی گلخانه' THEN bn.stage_id + 1
           WHEN f.request_type = 'تغییر کشت' THEN tk.stage_id + 1
           WHEN f.request_type = 'صدور بهره برداری گلخانه' THEN b.stage_id + 1
           WHEN f.request_type = 'اصلاح بهره برداری گلخانه' THEN eb.stage_id + 1
           WHEN f.request_type = 'تمدید توسعه گلخانه' THEN tt2.stage_id + 1
           WHEN f.request_type = 'تمدید بهره برداری گلخانه' THEN b2.stage_id + 1
           WHEN f.request_type = 'اصلاح تاسیس گلخانه' THEN et.stage_id + 1
           WHEN f.request_type = 'تمدید تاسیس قارچ' THEN ttgh.stage_id + 1
           WHEN f.request_type = 'تمدید توسعه قارچ' THEN ttgh.stage_id + 1
           ELSE s.stage_id + 1
       END AS next_stage_id
FROM files f
JOIN stages s ON f.stage_id = s.stage_id
LEFT JOIN ttstage tt ON f.request_type = 'تمدید تاسیس گلخانه' AND tt.stage_id = s.stage_id
LEFT JOIN tbdstage tb ON f.request_type = 'تمدید بهره برداری دام/طیور/شیلات' AND tb.stage_id = s.stage_id
LEFT JOIN tnstage tn ON f.request_type = 'تغییر نام گلخانه' AND tn.stage_id = s.stage_id
LEFT JOIN bnstage bn ON f.request_type = 'بهسازی و نوسازی گلخانه' AND bn.stage_id = s.stage_id
LEFT JOIN tkstage tk ON f.request_type = 'تغییر کشت' AND tk.stage_id = s.stage_id
LEFT JOIN bstage b ON f.request_type = 'صدور بهره برداری گلخانه' AND b.stage_id = s.stage_id
LEFT JOIN ebstage eb ON f.request_type = 'اصلاح بهره برداری گلخانه' AND eb.stage_id = s.stage_id
LEFT JOIN tt2stage tt2 ON f.request_type = 'تمدید توسعه گلخانه' AND tt2.stage_id = s.stage_id
LEFT JOIN b2stage b2 ON f.request_type = 'تمدید بهره برداری گلخانه' AND b2.stage_id = s.stage_id
LEFT JOIN etstage et ON f.request_type = 'اصلاح تاسیس گلخانه' AND et.stage_id = s.stage_id
LEFT JOIN ttghstage ttgh ON (f.request_type = 'تمدید تاسیس قارچ' OR f.request_type = 'تمدید توسعه قارچ') AND ttgh.stage_id = s.stage_id
WHERE f.assigned_to = ? AND f.status = 'جاری'";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

// تابع برای دریافت نام کاربر از user_id
function get_user_name($conn, $user_id) {
    $user_query = "SELECT first_name, last_name FROM users WHERE user_id = ?";
    $stmt = $conn->prepare($user_query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $user_result = $stmt->get_result();
    if ($user_row = $user_result->fetch_assoc()) {
        return $user_row['first_name'] . ' ' . $user_row['last_name'];
    }
    return "نامشخص";
}
?>
<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>صندوق ورودی</title>
    <link rel="stylesheet" href="inbox.css">
    <script>
    function startTimer(duration, display, row, stageName) {
    var timer = duration, days, hours, minutes, seconds;
    setInterval(function () {
        if (timer >= 0) {
            days = Math.floor(timer / 86400);
            hours = Math.floor((timer % 86400) / 3600);
            minutes = Math.floor((timer % 3600) / 60);
            seconds = timer % 60;

            days = days < 10 ? "0" + days : days;
            hours = hours < 10 ? "0" + hours : hours;
            minutes = minutes < 10 ? "0" + minutes : minutes;
            seconds = seconds < 10 ? "0" + seconds : seconds;

            display.textContent = days + " روز " + hours + ":" + minutes + ":" + seconds;

            // Apply highlight colors based on remaining time
            if (timer <= 0) {
                row.style.backgroundColor = stageName === "زمانبری پرداخت" ? "skyblue" : "red";
            } else if (timer <= 43200) { // less than 12 hours
                row.style.backgroundColor = "skyblue";
            } else if (timer <= 86400) { // between 12 and 24 hours
                row.style.backgroundColor = "orange";
            } else { // more than 24 hours
                row.style.backgroundColor = "";
            }

            if (--timer < 0) {
                display.textContent = "زمان تمام شده";
                row.style.backgroundColor = stageName === "زمانبری پرداخت" ? "skyblue" : "red";
            }
        }
    }, 1000);
}



window.onload = function () {
    var timers = document.querySelectorAll('.timer');
    timers.forEach(function(timerElement) {
        var allowedTime = parseInt(timerElement.dataset.allowedTime) * 60; // Convert minutes to seconds
        var startTime = new Date(timerElement.dataset.startTime).getTime();
        var now = new Date().getTime();
        var elapsedTime = Math.floor((now - startTime) / 1000);
        var remainingTime = allowedTime - elapsedTime;

        var row = timerElement.closest('tr');
        var stageName = row.cells[5].textContent.trim(); // Assuming stage name is in the 6th column (index 5)

        if (remainingTime > 0) {
            startTimer(remainingTime, timerElement, row, stageName);
        } else {
            timerElement.textContent = "زمان تمام شده";
            if (stageName === "زمانبری پرداخت") {
                row.style.backgroundColor = "skyblue";
            } else {
                row.style.backgroundColor = "red";
            }
        }
    });
};


</script>
</head>
<body>
<div class="container">
    <header>
        <h2>صندوق ورودی - <?php echo $user_first_name . " " . $user_last_name; ?></h2>
    </header>
    <main>
        <?php if ($result->num_rows > 0) { ?>
            <table>
                <thead>
                <tr>
                    <th>فایل آیدی</th>
                    <th>نام بهره بردار</th>
                    <th>نام خانوادگی بهره بردار</th>
                    <th>کد ملی</th>
                    <th>نوع درخواست</th>
                    <th>مرحله</th>
                    <th>زمان باقی‌مانده</th>
                    <th>نام ارجاع گیرنده بعدی</th>
                    <th>ثبت نظر</th>
                    <th>یادداشت‌های موقت</th>
                    <th>نمایش روند نما</th>
                </tr>
                </thead>
                <tbody>
                <?php 
                $conn = new mysqli($servername, $username, $password, $dbname);
                while ($row = $result->fetch_assoc()) { 
                    $next_user_name = "نامشخص";
                    if ($row['request_type'] == 'تمدید تاسیس گلخانه') {
                        $next_stage_query = "SELECT user_id FROM ttstage WHERE stage_id = ?";
                        $stmt = $conn->prepare($next_stage_query);
                        $stmt->bind_param("i", $row['next_stage_id']);
                        $stmt->execute();
                        $next_stage_result = $stmt->get_result();
                        if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                            $next_user_name = get_user_name($conn, $next_stage_row['user_id']);
                        }
                    } elseif ($row['request_type'] == 'تمدید بهره برداری دام/طیور/شیلات') {
                        $next_stage_query = "SELECT user_id FROM tbdstage WHERE stage_id = ?";
                        $stmt = $conn->prepare($next_stage_query);
                        $stmt->bind_param("i", $row['next_stage_id']);
                        $stmt->execute();
                        $next_stage_result = $stmt->get_result();
                        if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                            $next_user_name = get_user_name($conn, $next_stage_row['user_id']);
                        }
                    } elseif ($row['request_type'] == 'تغییر نام گلخانه') {
                        $next_stage_query = "SELECT user_id FROM tnstage WHERE stage_id = ?";
                        $stmt = $conn->prepare($next_stage_query);
                        $stmt->bind_param("i", $row['next_stage_id']);
                        $stmt->execute();
                        $next_stage_result = $stmt->get_result();
                        if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                            $next_user_name = get_user_name($conn, $next_stage_row['user_id']);
                        }
                    } elseif ($row['request_type'] == 'بهسازی و نوسازی گلخانه') {
                        $next_stage_query = "SELECT user_id FROM bnstage WHERE stage_id = ?";
                        $stmt = $conn->prepare($next_stage_query);
                        $stmt->bind_param("i", $row['next_stage_id']);
                        $stmt->execute();
                        $next_stage_result = $stmt->get_result();
                        if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                            $next_user_name = get_user_name($conn, $next_stage_row['user_id']);
                        }
                    } elseif ($row['request_type'] == 'تغییر کشت') {
                        $next_stage_query = "SELECT user_id FROM tkstage WHERE stage_id = ?";
                        $stmt = $conn->prepare($next_stage_query);
                        $stmt->bind_param("i", $row['next_stage_id']);
                        $stmt->execute();
                        $next_stage_result = $stmt->get_result();
                        if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                            $next_user_name = get_user_name($conn, $next_stage_row['user_id']);
                        }
                    } elseif ($row['request_type'] == 'صدور بهره برداری گلخانه') {
                        $next_stage_query = "SELECT user_id FROM bstage WHERE stage_id = ?";
                        $stmt = $conn->prepare($next_stage_query);
                        $stmt->bind_param("i", $row['next_stage_id']);
                        $stmt->execute();
                        $next_stage_result = $stmt->get_result();
                        if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                            $next_user_name = get_user_name($conn, $next_stage_row['user_id']);
                        }
                    } elseif ($row['request_type'] == 'اصلاح بهره برداری گلخانه') {
                        $next_stage_query = "SELECT user_id FROM ebstage WHERE stage_id = ?";
                        $stmt = $conn->prepare($next_stage_query);
                        $stmt->bind_param("i", $row['next_stage_id']);
                        $stmt->execute();
                        $next_stage_result = $stmt->get_result();
                        if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                            $next_user_name = get_user_name($conn, $next_stage_row['user_id']);
                        }
                    } elseif ($row['request_type'] == 'تمدید توسعه گلخانه') {
                        $next_stage_query = "SELECT user_id FROM tt2stage WHERE stage_id = ?";
                        $stmt = $conn->prepare($next_stage_query);
                        $stmt->bind_param("i", $row['next_stage_id']);
                        $stmt->execute();
                        $next_stage_result = $stmt->get_result();
                        if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                            $next_user_name = get_user_name($conn, $next_stage_row['user_id']);
                        }
                    } elseif ($row['request_type'] == 'تمدید بهره برداری گلخانه') {
                        $next_stage_query = "SELECT user_id FROM b2stage WHERE stage_id = ?";
                        $stmt = $conn->prepare($next_stage_query);
                        $stmt->bind_param("i", $row['next_stage_id']);
                        $stmt->execute();
                        $next_stage_result = $stmt->get_result();
                        if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                            $next_user_name = get_user_name($conn, $next_stage_row['user_id']);
                        }
                    } elseif ($row['request_type'] == 'اصلاح تاسیس گلخانه') {
                        $next_stage_query = "SELECT user_id FROM etstage WHERE stage_id = ?";
                        $stmt = $conn->prepare($next_stage_query);
                        $stmt->bind_param("i", $row['next_stage_id']);
                        $stmt->execute();
                        $next_stage_result = $stmt->get_result();
                        if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                            $next_user_name = get_user_name($conn, $next_stage_row['user_id']);
                        } elseif ($row['request_type'] == 'تمدید تاسیس قارچ' || $row['request_type'] == 'تمدید توسعه قارچ') {
                            $next_stage_query = "SELECT allowed_time FROM ttghstage WHERE stage_id = ?";
                            $stmt = $conn->prepare($next_stage_query);
                            $stmt->bind_param("i", $row['next_stage_id']);
                            $stmt->execute();
                            $next_stage_result = $stmt->get_result();
                             if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                                $allowed_time = $next_stage_row['allowed_time'];
                                $remaining_time = $allowed_time * 60 - $elapsed_time; // زمان باقی‌مانده را محاسبه کنید
                             if ($remaining_time < 0) {
                                 $remaining_time = 0; // اگر زمان منفی شد، به صفر تنظیم کنید
                                }
                            $row['allowed_time'] = $allowed_time; // مقدار زمان مجاز را برای نمایش در جدول تنظیم کنید
                            $row['remaining_time'] = $remaining_time; // مقدار زمان باقی‌مانده را برای نمایش در جدول تنظیم کنید
                        }
                    }
                    } else {
                        $next_stage_query = "SELECT user_id FROM stages WHERE stage_id = ?";
                        $stmt = $conn->prepare($next_stage_query);
                        $stmt->bind_param("i", $row['next_stage_id']);
                        $stmt->execute();
                        $next_stage_result = $stmt->get_result();
                        if ($next_stage_row = $next_stage_result->fetch_assoc()) {
                            $next_user_name = get_user_name($conn, $next_stage_row['user_id']);
                        }
                    }
                ?>
                    <tr>
                        <td><?php echo $row['file_id']; ?></td>
                        <td><?php echo $row['operator_first_name']; ?></td>
                        <td><?php echo $row['operator_last_name']; ?></td>
                        <td><?php echo $row['national_code']; ?></td>
                        <td><?php echo $row['request_type']; ?></td>
                        <td><?php echo $row['stage_name']; ?></td>
                        <td>
                            <span class="timer" data-allowed-time="<?php echo $row['allowed_time']; ?>" data-start-time="<?php echo $row['stage_start_time']; ?>"></span>
                        </td>
                        <td><?php echo $next_user_name; ?></td>
                        <td>
                            <form class="comment-form" action="save_comment.php" method="post">
                                <input type="hidden" name="file_id" value="<?php echo $row['file_id']; ?>">
                                <textarea name="comment" rows="3" cols="30" placeholder="عملیات انجام شده را شرح دهید"></textarea>
                                <button type="submit">ثبت نظر</button>
                            </form>
                            <form action="view_comments.php" method="get" style="display:inline;">
                                <input type="hidden" name="file_id" value="<?php echo $row['file_id']; ?>">
                                <button type="submit">نمایش نظرات</button>
                            </form>
                        <td>
                            <form class="temp-notes-form" action="save_temp_notes.php" method="post">
                                <input type="hidden" name="file_id" value="<?php echo $row['file_id']; ?>">
                                <textarea name="temp_notes" rows="3" cols="30" placeholder="یادداشت‌های موقت"></textarea>
                                <button type="submit">ثبت یادداشت</button>
                            </form>
                            <form action="view_temp_notes.php" method="get" style="display:inline;">
                                <input type="hidden" name="file_id" value="<?php echo $row['file_id']; ?>">
                                <button type="submit">نمایش یادداشت‌های موقت</button>
                             </form>
                             
                        </td>
                        <td>
                            <form action="workflow_view.php" method="get" style="display:inline;">
                                <input type="hidden" name="file_id" value="<?php echo $row['file_id']; ?>">
                                <button type="submit">نمایش ورک‌فلو</button>
                            </form>
                        </td>
                        </td>
                    </tr>
                <?php 
                } 
                $conn->close();
                ?>
                </tbody>
            </table>
        <?php } else { ?>
            <p>پرونده‌ای برای شما ارجاع داده نشده است.</p>
        <?php } ?>
    </main>
    <footer>
        <a href="user_dashboard.php">بازگشت به داشبورد</a>
        <form action="logout.php" method="post" style="display:inline;">
            <button type="submit">خروج</button>
        </form>
    </footer>
</div>
</body>
</html>