<?php
session_start();
require_once "db_connection.php";

// چک کردن ورود کاربر
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// دریافت شناسه کاربر از جلسه
$user_id = $_SESSION['user_id'];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $reference_code = $_POST["reference_code"];

    // دریافت file_id بر اساس reference_code
    $conn = new mysqli("localhost", "anreoalb_archive", "Shahrooz@2681", "anreoalb_archive");
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    $file_query = "SELECT file_id, request_type, stage_id FROM files WHERE temp_code = ?";
    $stmt_file = $conn->prepare($file_query);
    $stmt_file->bind_param("s", $reference_code);
    $stmt_file->execute();
    $result = $stmt_file->get_result();
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $file_id = $row['file_id'];
        $request_type = $row['request_type'];
        $current_stage_id = $row['stage_id'];
    } else {
        echo "<script>alert('خطا: پرونده‌ای با این کد ارجاع یافت نشد.'); window.history.back();</script>";
        exit;
    }

    // بررسی نوع درخواست و دریافت مراحل جدید بر اساس نوع درخواست
    switch ($request_type) {
        case "تمدید تاسیس قارچ":
        case "تمدید توسعه قارچ":
            $stages_table = "ttghstage";
            break;
        case "تمدید بهره برداری قارچ":
            $stages_table = "tbghstage";
            break;
        case "صدور تاسیس گلخانه":
        case "توسعه گلخانه":
            $stages_table = "stages";
            break;
        case "تمدید بهره برداری گلخانه":
            $stages_table = "b2stage";
            break;
        case "تغییر نام گلخانه":
            $stages_table = "tnstage";
            break;
        case "تغییر کشت":
            $stages_table = "tkstage";
            break;
        case "صدور بهره برداری گلخانه":
            $stages_table = "bstage";
            break;
        case "اصلاح بهره برداری گلخانه":
            $stages_table = "ebstage";
            break;
        case "تمدید تاسیس گلخانه":
            $stages_table = "ttstage";
            break;
        case "تمدید توسعه گلخانه":
            $stages_table = "tt2stage";
            break;
        case "اصلاح تاسیس گلخانه":
            $stages_table = "etstage";
            break;
        case "بهسازی و نوسازی گلخانه":
            $stages_table = "bnstage";
            break;
        case "اصلاح تاسیس دام/طیور/شیلات":
        case "اصلاح بهره برداری دام/طیور/شیلات":
            $stages_table = "etdstage";
            break;
        case "تمدید بهره برداری دام/طیور/شیلات":
            $stages_table = "tbdstage";
            break;
        case "تمدید تاسیس دام/طیور/شیلات":
            $stages_table = "ttdstage";
            break;
        case "صدور بهره برداری دام/طیور/شیلات":
            $stages_table = "sbdstage";
            break;
        case "توسعه و افزایش ظرفیت دام/طیور/شیلات":
            $stages_table = "tazstage";
            break;
        case "موافقت اصولی دام/طیور/شیلات":
            $stages_table = "mostage";
            break;
        case "بهسازی و نوسازی دام/طیور/شیلات":
            $stages_table = "bndstage";
            break;
        case "تغییر نام تاسیس دام/طیور/شیلات":
        case "تغییر نام بهره برداری دام/طیور/شیلات":
            $stages_table = "tntstage";
            break;
        case "صدور دامداری غیر صنعتی":
            $stages_table = "sdgstage";
            break;
        case "تمدید دامداری غیر صنعتی":
            $stages_table = "tdgstage";
            break;
        case "اصلاح دامداری غیر صنعتی":
            $stages_table = "edgstage";
            break;
        case "صدور بهره برداری انسکتاریوم":
            $stages_table = "sistage";
            break;
        case "تمدید بهره برداری انسکتاریوم":
            $stages_table = "tbistage";
            break;
        case "اصلاح انسکتاریوم":
            $stages_table = "eistage";
            break;
        case "تغییر نام انسکتاریوم":
            $stages_table = "tnistage";
            break;
        case "صدور تاسیس داروخانه گیاهپزشکی":
            $stages_table = "stgstage";
            break;
        case "اصلاح تاسیس و بهره برداری کلینیک":
        case "اصلاح تاسیس داروخانه":
            $stages_table = "etbcstage";
            break;
        case "صدور تاسیس کلینیک گیاهپزشکی":
            $stages_table = "tscstage";
            break;
        case "صدور بهره برداری کلینیک گیاهپزشکی":
            $stages_table = "sbcstage";
            break;
        case "تمدید تاسیس داروخانه":
        case "تمدید کلینیک گیاهپزشکی":
            $stages_table = "ttcstage";
            break;
        case "تمدید تاسیس انسکتاریوم":
            $stages_table = "ttistage";
            break;
        case "صدور تاسیس انسکتاریوم":
            $stages_table = "stistage";
            break;
        case "تغییر نام بهره برداری دام":
            $stages_table = "tntstage";
            break;
        case "صدور تاسیس دام/طیور/شیلات":
            $stages_table = "stdstage";
            break;
        // اضافه کردن موارد جدید
        case "صدور توسعه قارچ":
        case "صدور تاسیس قارچ":
            $stages_table = "stghstage";
            break;
        default:
            $stages_table = null;
            break;
    }

    if ($stages_table) {
        // افزایش stage_id به اندازه یک واحد
        $new_stage_id = $current_stage_id + 1;

        // بازیابی stage_name و user_id جدید از جدول مربوطه
        $new_stage_query = "SELECT stage_name, user_id FROM $stages_table WHERE stage_id = ?";
        $stmt_stage = $conn->prepare($new_stage_query);
        $stmt_stage->bind_param("i", $new_stage_id);
        $stmt_stage->execute();
        $result_stage = $stmt_stage->get_result();
        if ($result_stage->num_rows > 0) {
            $new_stage_row = $result_stage->fetch_assoc();
            $new_stage_name = $new_stage_row['stage_name'];
            $new_assigned_to = $new_stage_row['user_id'];

            // بررسی اینکه آیا کاربر فعلی همان کاربر جدید است
            if ($user_id != $new_assigned_to) {
                echo "<script>alert('این پرونده متعلق به شما نمی‌باشد.'); window.history.back();</script>";
                exit;
            }
        } else {
            // اگر مرحله جدید وجود نداشت، وضعیت پرونده را به خاتمه یافته تغییر دهید و assigned_to را NULL کنید
            $finalize_query = "UPDATE files SET status = 'خاتمه یافته', assigned_to = NULL, temporary_note = NULL WHERE file_id = ?";
            $stmt_finalize = $conn->prepare($finalize_query);
            $stmt_finalize->bind_param("i", $file_id);
            if ($stmt_finalize->execute()) {
                echo "<script>alert('پرونده با موفقیت خاتمه یافت. لطفا پرونده را بایگانی فرمایید'); window.location.href='inbox.php';</script>";
                exit;
            } else {
                echo "<script>alert('خطا در به‌روزرسانی وضعیت فایل: " . $conn->error . "'); window.history.back();</script>";
                exit;
            }
        }

        // زمان فعلی
        $current_time = date("Y-m-d H:i:s");

        // به‌روزرسانی stage_id، stage_name، assigned_to، stage_start_time و temporary_note در جدول files
        $update_query = "UPDATE files SET stage_id = ?, stage_name = ?, assigned_to = ?, stage_start_time = ?, temporary_note = NULL WHERE file_id = ?";
        $stmt_update = $conn->prepare($update_query);
        $stmt_update->bind_param("isisi", $new_stage_id, $new_stage_name, $new_assigned_to, $current_time, $file_id);
        if (!$stmt_update->execute()) {
            echo "<script>alert('خطا در به‌روزرسانی فایل: " . $conn->error . "'); window.history.back();</script>";
            exit;
        }
        
        // تنظیم temp_code به NULL بعد از تمام عملیات موفقیت‌آمیز
        $update_temp_code_query = "UPDATE files SET temp_code = NULL WHERE file_id = ?";
        $stmt_update_temp_code = $conn->prepare($update_temp_code_query);
        $stmt_update_temp_code->bind_param("i", $file_id);
        if (!$stmt_update_temp_code->execute()) {
            echo "<script>alert('خطا در به‌روزرسانی کد ارجاع: " . $conn->error . "'); window.history.back();</script>";
            exit;
        }
    }

    // بستن اتصال به دیتابیس
    $stmt_file->close();
    if (isset($stmt_stage)) {
        $stmt_stage->close();
    }
    if (isset($stmt_update)) {
        $stmt_update->close();
    }
    if (isset($stmt_finalize)) {
        $stmt_finalize->close();
    }
    $conn->close();

    // بازگشت به صفحه صندوق ورودی
    header("Location: inbox.php");
    exit;
}
?>
