<?php
require 'jdf.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_FILES['kml_file']) || $_FILES['kml_file']['error'] !== UPLOAD_ERR_OK) {
        die("آپلود فایل KML با خطا مواجه شد.");
    }

    if (!isset($_POST['date']) || empty(trim($_POST['date']))) {
        die("تاریخ شمسی ارسال نشده است.");
    }

    $shamsi_date = trim($_POST['date']);
    $parts = explode('-', $shamsi_date);
    if (count($parts) !== 3) {
        die("فرمت تاریخ شمسی اشتباه است. باید به شکل YYYY-MM-DD باشد.");
    }
    list($jy, $jm, $jd) = $parts;
    list($gy, $gm, $gd) = jalali_to_gregorian(intval($jy), intval($jm), intval($jd));
    $timestamp_str = sprintf('%04d-%02d-%02dT%sZ', $gy, $gm, $gd, date('H:i:s'));

    // خواندن محتوای فایل
    $tmpName = $_FILES['kml_file']['tmp_name'];
    $original_content = file_get_contents($tmpName);
    if ($original_content === false) {
        die("خواندن فایل KML امکان‌پذیر نیست.");
    }

    // اضافه کردن کامنت بالا
    $output_content = preg_replace('/(<\?xml[^>]+>)/', "$1\n<!-- TimeStamp (Gregorian): $timestamp_str -->", $original_content, 1);

    // درج TimeStamp به ازای هر Placemark
    $output_content = preg_replace_callback(
        '/<Placemark>(.*?)<\/Placemark>/s',
        function ($matches) use ($timestamp_str) {
            $placemark = $matches[1];
            // اگر قبلاً TimeStamp ندارد، اضافه کن
            if (strpos($placemark, '<TimeStamp>') === false) {
                $timestamp_xml = "<TimeStamp><when>$timestamp_str</when></TimeStamp>\n";
                return "<Placemark>\n$timestamp_xml$placemark</Placemark>";
            } else {
                return "<Placemark>$placemark</Placemark>";
            }
        },
        $output_content
    );

    // ذخیره فایل خروجی
    $output_filename = 'new_kml_' . str_replace('-', '', $shamsi_date) . '_' . time() . '.kml';
    $saved = file_put_contents($output_filename, $output_content);

    if ($saved === false) {
        die("نوشتن فایل خروجی با خطا مواجه شد.");
    } else {
        echo "✅ فایل KML جدید با TimeStamp ساخته شد: <a href='$output_filename' target='_blank'>$output_filename</a><br><br>";
        echo nl2br(htmlspecialchars($output_content));
    }
} else {
    echo "لطفا از طریق فرم اقدام کنید.";
}
