<?php
require_once "db_connection.php";

// هندل انتخاب‌ها از hidden input
$selected_ids = [];
if (!empty($_POST['selected_rows_json'])) {
    $selected_ids = json_decode($_POST['selected_rows_json'], true) ?? [];
}

// تابع برای گرفتن فایل‌ها بر اساس فیلتر
function getFilteredRows($conn, $filters = []) {
    $query = "SELECT * FROM karshenasan WHERE 1=1";

    if (!empty($filters['request_type'])) {
        $request_type = $conn->real_escape_string($filters['request_type']);
        $query .= " AND request_type LIKE '%$request_type%'";
    }

    if (!empty($filters['stage'])) {
        $stage = intval($filters['stage']);
        $query .= " AND file$stage IS NOT NULL AND file$stage != ''";
    }

    if (!empty($filters['search'])) {
        $search = $conn->real_escape_string($filters['search']);
        $query .= " AND (first_name LIKE '%$search%' OR last_name LIKE '%$search%' OR national_code LIKE '%$search%')";
    }

    return $conn->query($query);
}

// گرفتن نوع درخواست‌ها از دیتابیس
function getRequestTypes($conn) {
    $query = "SELECT DISTINCT request_type FROM karshenasan WHERE request_type IS NOT NULL AND request_type != ''";
    return $conn->query($query);
}

// هندل دانلود فایل‌ها برای ردیف‌های انتخاب‌شده
if (isset($_POST['download_selected'])) {
    if (empty($selected_ids)) {
        echo "<script>alert('هیچ فایلی انتخاب نشده است');</script>";
    } else {
        $files = [];
        foreach ($selected_ids as $row_id) {
            $result = $conn->query("SELECT * FROM karshenasan WHERE id = $row_id");
            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                for ($i = 1; $i <= 10; $i++) {
                    if (!empty($row["file$i"])) {
                        $filename = "مرحله{$i}_{$row['first_name']}_{$row['last_name']}";
                        $ext = pathinfo($row["file$i"], PATHINFO_EXTENSION);
                        $files[] = [
                            'path' => "k_uploads/" . $row["file$i"],
                            'name' => $filename . "." . $ext
                        ];
                    }
                }
            }
        }

        if (!empty($files)) {
            $zip = new ZipArchive();
            $zipName = "downloads_" . time() . ".zip";
            $zipPath = __DIR__ . "/" . $zipName;

            if ($zip->open($zipPath, ZipArchive::CREATE) === TRUE) {
                foreach ($files as $file) {
                    if (file_exists($file['path'])) {
                        $zip->addFile($file['path'], $file['name']);
                    }
                }
                $zip->close();

                header("Content-Type: application/zip");
                header("Content-Disposition: attachment; filename=$zipName");
                header("Content-Length: " . filesize($zipPath));
                readfile($zipPath);
                unlink($zipPath);
                exit;
            }
        } else {
            echo "<script>alert('هیچ فایلی برای دانلود انتخاب نشده است');</script>";
        }
    }
}

// گرفتن داده‌ها برای نمایش جدول
$filters = [
    'request_type' => $_POST['request_type'] ?? '',
    'stage' => $_POST['stage'] ?? '',
    'search' => $_POST['search'] ?? ''
];
$result = getFilteredRows($conn, $filters);

// گرفتن نوع درخواست‌ها از دیتابیس
$request_types_result = getRequestTypes($conn);
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مرکز دانلود گزارشات</title>
    <link rel="stylesheet" href="bootstrap/css/bootstrap.rtl.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body class="bg-light">
<div class="container mt-5">
    <h4 class="text-center mb-4">مرکز دانلود گزارشات ۶ ماهه اراضی</h4>

    <form method="post" class="mb-4 border p-3 rounded bg-white shadow-sm">
        <input type="hidden" name="selected_rows_json" id="selected_rows_json" value="<?= htmlspecialchars(json_encode($selected_ids)) ?>">

        <div class="row g-2">
            <div class="col-md-3">
                <input type="text" name="search" class="form-control" placeholder="جستجو بر اساس نام، نام خانوادگی یا کد ملی" value="<?= htmlspecialchars($filters['search']) ?>">
            </div>
            <div class="col-md-3">
                <select name="request_type" id="request_type" class="form-select">
                    <option value="">نوع درخواست</option>
                    <?php while ($row = $request_types_result->fetch_assoc()): ?>
                        <option value="<?= htmlspecialchars($row['request_type']) ?>" <?= ($filters['request_type'] == $row['request_type']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($row['request_type']) ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div class="col-md-2">
                <select name="stage" class="form-select">
                    <option value="">همه مراحل</option>
                    <?php for ($i = 1; $i <= 10; $i++): ?>
                        <option value="<?= $i ?>" <?= ($filters['stage'] == $i) ? 'selected' : '' ?>>مرحله <?= $i ?></option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-success w-100">فیلتر</button>
            </div>
            <div class="col-md-2">
                <button type="submit" name="download_selected" class="btn btn-primary w-100">دانلود فایل‌های انتخاب‌شده</button>
            </div>
        </div>

        <div class="table-responsive bg-white p-3 shadow-sm rounded mt-4">
            <table class="table table-bordered table-hover align-middle text-center small">
                <thead class="table-light">
                    <tr>
                        <th><input type="checkbox" id="select_all"></th>
                        <th>ردیف</th>
                        <th>کد پرونده</th>
                        <th>نام</th>
                        <th>نام خانوادگی</th>
                        <th>کد ملی</th>
                        <th>شماره همراه</th>
                        <th>نوع درخواست</th>
                        <?php for ($i = 1; $i <= 10; $i++): ?>
                            <th>مرحله <?= $i ?></th>
                        <?php endfor; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): ?>
                        <?php $row_number = 1; ?>
                        <?php while ($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><input type="checkbox" name="selected_rows[]" value="<?= $row['id'] ?>" <?= in_array($row['id'], $selected_ids) ? 'checked' : '' ?>></td>
                                <td><?= $row_number++ ?></td>
                                <td><?= $row['id'] ?? '-' ?></td>
                                <td><?= $row['first_name'] ?? '-' ?></td>
                                <td><?= $row['last_name'] ?? '-' ?></td>
                                <td><?= $row['national_code'] ?? '-' ?></td>
                                <td><?= $row['phone_number'] ?? '-' ?></td>
                                <td><?= $row['request_type'] ?? '-' ?></td>
                                <?php for ($i = 1; $i <= 10; $i++): ?>
                                    <?php
                                        $file = $row["file$i"];
                                        $expert = $row["expert$i"];
                                        $date = $row["date$i"];
                                        $bg_class = '';

                                        if (!empty($file)) {
                                            $bg_class = 'table-success';
                                        } elseif (!empty($date) && strtotime($date) < strtotime(date('Y-m-d'))) {
                                            $bg_class = 'table-danger';
                                        }
                                    ?>
                                    <td class="<?= $bg_class ?>">
                                        <?php if (!empty($file)): ?>
                                            <a href="k_uploads/<?= $file ?>" target="_blank" class="btn btn-sm btn-outline-primary">دانلود</a><br>
                                            <small><?= $expert ?></small><br>
                                            <small class="text-muted"><?= $date ?></small>
                                        <?php elseif (!empty($date)): ?>
                                            <small class="text-muted"><?= $date ?></small>
                                        <?php else: ?>
                                            <span class="text-muted">---</span>
                                        <?php endif; ?>
                                    </td>
                                <?php endfor; ?>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="15">هیچ گزارشی یافت نشد.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </form>
</div>

<script>
    let selectedIds = new Set();

    // مقدار اولیه از hidden input
    const oldSelected = document.getElementById('selected_rows_json').value;
    if (oldSelected) {
        try {
            JSON.parse(oldSelected).forEach(id => selectedIds.add(id));
        } catch (e) {}
    }

    // تنظیم تیک‌ها هنگام بارگذاری مجدد صفحه
    document.querySelectorAll('input[name="selected_rows[]"]').forEach(cb => {
        if (selectedIds.has(cb.value)) cb.checked = true;

        cb.addEventListener('change', () => {
            const id = cb.value;
            if (cb.checked) {
                selectedIds.add(id);
            } else {
                selectedIds.delete(id);
            }
        });
    });

    // انتخاب همه
    document.getElementById('select_all').addEventListener('click', function () {
        const checkboxes = document.querySelectorAll('input[name="selected_rows[]"]');
        checkboxes.forEach(cb => {
            cb.checked = this.checked;
            const id = cb.value;
            if (this.checked) {
                selectedIds.add(id);
            } else {
                selectedIds.delete(id);
            }
        });
    });

    // هنگام ارسال فرم
    document.querySelector('form').addEventListener('submit', function () {
        document.getElementById('selected_rows_json').value = JSON.stringify(Array.from(selectedIds));
    });
</script>
</body>
</html>
