<?php
session_start();
require_once "db_connection.php";

// چک کردن ورود کاربر
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// دریافت file_id از درخواست
$file_id = isset($_POST['file_id']) ? intval($_POST['file_id']) : 0;

if ($file_id === 0) {
    echo "شناسه پرونده معتبر نیست.";
    exit;
}

// اتصال به دیتابیس
$conn = new mysqli("localhost", "anreoalb_archive", "Shahrooz@2681", "anreoalb_archive");

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// کوئری برای بازیابی نظرات مربوط به فایل
$query = "SELECT comment, created_at, user_id FROM comments WHERE file_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $file_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo "<h3>نظرات مربوط به پرونده شماره $file_id</h3>";
    echo "<ul>";
    while ($row = $result->fetch_assoc()) {
        $user_name = get_user_name($conn, $row['user_id']);
        echo "<li><strong>$user_name:</strong> " . $row['comment'] . " <em>(" . $row['created_at'] . ")</em></li>";
    }
    echo "</ul>";
} else {
    echo "هیچ نظری برای این پرونده ثبت نشده است.";
}

// تابع برای دریافت نام کاربر از user_id
function get_user_name($conn, $user_id) {
    $user_query = "SELECT first_name, last_name FROM users WHERE user_id = ?";
    $stmt = $conn->prepare($user_query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $user_result = $stmt->get_result();
    if ($user_row = $user_result->fetch_assoc()) {
        return $user_row['first_name'] . ' ' . $user_row['last_name'];
    }
    return "نامشخص";
}

$stmt->close();
$conn->close();
?>
