<?php
session_start();
require_once "db_connection.php";

// بررسی ورود کاربر
if (!isset($_SESSION['username'])) {
    header("Location: login.html");
    exit;
}

// اتصال به دیتابیس
$conn = new mysqli($servername, $username, $password, $dbname);

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// بازیابی اطلاعات کاربر
$user_id = $_SESSION['user_id'];

// بازیابی نام و نام خانوادگی کاربر و نقش
$user_sql = "SELECT CONCAT(first_name, ' ', last_name) AS full_name, role FROM users WHERE user_id = ?";
$stmt = $conn->prepare($user_sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user_result = $stmt->get_result();
$user = $user_result->fetch_assoc();
$stmt->close();

if (!$user) {
    die("User not found.");
}

$full_name = $user['full_name'];
$role = $user['role'];

// بازیابی نام‌های پاسخ‌دهنده
$responder_names = [];
$responder_sql = "SELECT DISTINCT reply_user FROM letters WHERE reply_user IS NOT NULL
                  UNION
                  SELECT DISTINCT reply_user_1 FROM letters WHERE reply_user_1 IS NOT NULL
                  UNION
                  SELECT DISTINCT reply_user_2 FROM letters WHERE reply_user_2 IS NOT NULL
                  UNION
                  SELECT DISTINCT reply_user_3 FROM letters WHERE reply_user_3 IS NOT NULL
                  UNION
                  SELECT DISTINCT reply_user_4 FROM letters WHERE reply_user_4 IS NOT NULL";
$responder_result = $conn->query($responder_sql);

if ($responder_result === false) {
    die("Error executing query: " . $conn->error);
}

if ($responder_result->num_rows > 0) {
    while ($row = $responder_result->fetch_assoc()) {
        $responder_names[] = $row['reply_user'];
    }
}

// بررسی فیلد جستجو
$search_user = isset($_GET['search_user']) ? $_GET['search_user'] : '';
$show_closed = isset($_GET['show_closed']) ? $_GET['show_closed'] : '0';

// کوئری برای بازیابی تمامی نامه‌های مهم با توجه به فیلتر جستجو و وضعیت
$sql = "SELECT id, subject, description, end_date, reply, reply_user, reply_1, reply_user_1, reply_2, reply_user_2, reply_3, reply_user_3, reply_4, reply_user_4, reply_status, attachment_path, first_assignee_name
        FROM letters";

$where_clauses = [];

if (!empty($search_user)) {
    $where_clauses[] = "(reply_user LIKE '%$search_user%' 
              OR reply_user_1 LIKE '%$search_user%' 
              OR reply_user_2 LIKE '%$search_user%' 
              OR reply_user_3 LIKE '%$search_user%' 
              OR reply_user_4 LIKE '%$search_user%')";
}

if ($show_closed !== '1') {
    $where_clauses[] = "reply_status != 'خاتمه یافته'";
}

if (!empty($where_clauses)) {
    $sql .= " WHERE " . implode(" AND ", $where_clauses);
}

$sql .= " ORDER BY FIELD(reply_status, 'پاسخ داده شده') DESC, FIELD(reply_status, 'خاتمه یافته') DESC, end_date DESC";

$result = $conn->query($sql);

if ($result === false) {
    die("Error executing query: " . $conn->error);
}

$conn->close();
?>

<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>نامه‌های مهم</title>
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
<style>
/* اضافه کردن استایل برای عریض کردن ستون توضیحات */
.table-description {
    width: 300px; /* تنظیم عرض دلخواه */
}

/* استایل برای هایلایت کردن ردیف‌ها */
.table-danger-highlight {
    background-color: #f8d7da; /* رنگ پس‌زمینه قرمز روشن */
    color: #721c24; /* رنگ متن قرمز تیره */
}

/* استایل برای استیکی کردن دکمه بازگشت به صفحه اصلی */
.sticky-footer {
    position: fixed;
    bottom: 0;
    width: 100%;
    background-color: white;
    padding: 10px 0;
    box-shadow: 0 -2px 5px rgba(0, 0, 0, 0.1);
    text-align: center;
}
</style>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script>
// تابع برای نمایش زمان باقی‌مانده یا زمان گذشته
function showRemainingTime(endTime) {
    var now = new Date();
    var end = new Date(endTime);
    var remaining = end - now;

    var days = Math.abs(Math.floor(remaining / (1000 * 60 * 60 * 24)));
    var hours = Math.abs(Math.floor((remaining % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60)));
    var minutes = Math.abs(Math.floor((remaining % (1000 * 60 * 60)) / (1000 * 60)));
    var seconds = Math.abs(Math.floor((remaining % (1000 * 60)) / 1000));

    if (remaining >= 0) {
        return days + " روز و " + hours + " ساعت و " + minutes + " دقیقه و " + seconds + " ثانیه";
    } else {
        return days + " روز و " + hours + " ساعت و " + minutes + " دقیقه و " + seconds + " ثانیه پیش";
    }
}
</script>
</head>
<body class="container mt-5" dir="rtl">
<div class="container">
  <header class="mb-4">
    <h2>نامه‌های مهم</h2>
  </header>
  <main>
    <div class="mb-3">
        <?php
        if (!empty($responder_names)) {
            foreach ($responder_names as $name) {
                echo "<a href='?search_user=" . urlencode($name) . "' class='btn btn-info m-1'>" . htmlspecialchars($name) . "</a>";
            }
        } else {
            echo "<div class='alert alert-info'>هیچ پاسخ‌دهنده‌ای یافت نشد.</div>";
        }
        ?>
    </div>
    <form method="GET" action="">
        <input type="hidden" name="show_closed" value="<?php echo $show_closed === '1' ? '0' : '1'; ?>">
        <button type="submit" class="btn btn-primary">
            <?php echo $show_closed === '1' ? 'عدم نمایش نامه‌های خاتمه‌یافته' : 'نمایش نامه‌های خاتمه‌یافته'; ?>
        </button>
    </form>
    <?php
    if ($result->num_rows > 0) {
        // چاپ جدول نامه‌های مهم
        echo "<table class='table table-striped text-right'>";
        echo "<thead class='thead-dark'><tr><th>عنوان نامه</th><th class='table-description'>توضیحات</th><th>زمان باقی‌مانده</th><th>وضعیت</th><th>پیوست</th><th>نام اولین ارجاع‌گیرنده</th><th>پاسخ‌ها و پاسخ‌دهنده‌ها</th></tr></thead>";
        echo "<tbody>";
        while ($row = $result->fetch_assoc()) {
            $end_date = htmlspecialchars($row["end_date"]);
            $time_remaining = "<script>document.write(showRemainingTime('$end_date'))</script>";
            $is_past_due = (strtotime($end_date) < time());

            // تعیین کلاس CSS بر اساس وضعیت و زمان
            $row_class = "";
            if ($is_past_due && ($row["reply_status"] === NULL || $row["reply_status"] === "پاسخ داده شده")) {
                $row_class = "table-danger-highlight";
            }

            // نمایش نام اولین ارجاع‌گیرنده یا "فاقد اطلاعات" در صورت نال بودن
            $first_assignee_name = !empty($row["first_assignee_name"]) ? htmlspecialchars($row["first_assignee_name"]) : "فاقد اطلاعات";

            echo "<tr class='$row_class'>";
            echo "<td>" . htmlspecialchars($row["subject"]) . "</td>";
            echo "<td class='table-description'>" . htmlspecialchars($row["description"]) . "</td>";
            echo "<td>$time_remaining</td>";
            echo "<td>" . (is_null($row["reply_status"]) ? "جاری" : htmlspecialchars($row["reply_status"])) . "</td>";
            echo "<td>";
            if (!empty($row["attachment_path"])) {
                echo "<a href='" . htmlspecialchars($row["attachment_path"]) . "' download>دانلود پیوست</a>";
            } else {
                echo "بدون پیوست";
            }
            echo "</td>";
            echo "<td>$first_assignee_name</td>";
            echo "<td>";
            for ($i = 0; $i <= 4; $i++) {
                $reply_col = $i == 0 ? "reply" : "reply_$i";
                $reply_user_col = $i == 0 ? "reply_user" : "reply_user_$i";
                if (!is_null($row[$reply_col])) {
                    echo "<strong>" . htmlspecialchars($row[$reply_user_col]) . ":</strong> " . htmlspecialchars($row[$reply_col]) . "<br>";
                    if ($i < 4 && !is_null($row["reply_" . ($i + 1)])) {
                        echo "<hr>";
                    }
                }
            }
            echo "</td>";
            echo "</tr>";
        }
        echo "</tbody>";
        echo "</table>";
    } else {
        echo "<div class='alert alert-info'>نامه‌ای یافت نشد.</div>";
    }
    ?>
  </main>
  <footer class="sticky-footer">
    <a href="admin_dashboard.php" class="btn btn-secondary">بازگشت به صفحه اصلی</a>
  </footer>
</div>
</body>
</html>
