<?php
include 'db_connection.php';
session_start(); // شروع جلسه برای دسترسی به یوزر آی‌دی کاربر

// بررسی اینکه کاربر مجاز است یا خیر
$allowed_user_ids = [6, 2];
if (!in_array($_SESSION['user_id'], $allowed_user_ids)) {
    // هدایت به صفحه دیگری (مثلاً صفحه اصلی)
    header('Location: login.html');
    exit();
}

// انتخاب پرونده‌های معلق
$sql = "SELECT file_id, operator_first_name, operator_last_name, national_code, phone_number, request_type, status, sus_reason, sec_name 
        FROM files 
        WHERE status = 'معلق'";
$result = $conn->query($sql);

// انتخاب دبیرخانه‌ها برای دکمه‌های پری ست
$sec_names_sql = "SELECT DISTINCT sec_name FROM files WHERE status = 'معلق'";
$sec_names_result = $conn->query($sec_names_sql);

// تعیین مسیر بازگشت به داشبورد بر اساس user_id
$dashboard_url = '';
if ($_SESSION['user_id'] == 2) {
    $dashboard_url = 'archive_manager_dashboard.php';
} elseif ($_SESSION['user_id'] == 6) {
    $dashboard_url = 'admin_dashboard.php';
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پرونده‌های معلق</title>
    <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
    <style>
        body {
            direction: rtl;
            text-align: right;
        }
        table {
            margin-top: 20px;
        }
        .preset-buttons {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
            margin-bottom: 20px;
        }
        .preset-buttons button {
            flex: 1 1 auto;
            text-align: center;
        }
        .sticky-btn {
            position: -webkit-sticky; /* برای Safari */
            position: sticky;
            bottom: 0;
            background-color: #f8f9fa;
            border-top: 1px solid #ddd;
            padding: 10px;
            text-align: center;
            z-index: 1000;
        }
    </style>
    <script>
        function liveSearch() {
            let input = document.getElementById('searchInput');
            let filter = input.value.toLowerCase();
            let table = document.getElementById('filesTable');
            let trs = table.getElementsByTagName('tr');
            let row_number = 1; // برای شماره‌گذاری ردیف‌ها

            for (let i = 1; i < trs.length; i++) {
                let tds = trs[i].getElementsByTagName('td');
                let match = false;
                for (let j = 0; j < tds.length; j++) {
                    if (tds[j].innerText.toLowerCase().indexOf(filter) > -1) {
                        match = true;
                        break;
                    }
                }
                trs[i].style.display = match ? '' : 'none';
                if (match) {
                    trs[i].getElementsByTagName('td')[0].innerText = row_number++; // شماره‌گذاری مجدد
                }
            }
        }

        function filterBySecName(secName) {
            let input = document.getElementById('searchInput');
            input.value = secName;
            liveSearch();
        }

        function renumberRows() {
            let table = document.getElementById('filesTable');
            let trs = table.getElementsByTagName('tr');
            let row_number = 1;

            for (let i = 1; i < trs.length; i++) {
                if (trs[i].style.display !== 'none') {
                    trs[i].getElementsByTagName('td')[0].innerText = row_number++;
                }
            }
        }

        document.addEventListener('DOMContentLoaded', (event) => {
            renumberRows(); // شماره‌گذاری اولیه هنگام بارگذاری صفحه
        });
    </script>
</head>
<body>
<div class="container">
    <h1 class="mt-5">پرونده‌های معلق</h1>

    <!-- نوار جستجو -->
    <div class="row mb-3">
        <div class="col-md-12">
            <input type="text" id="searchInput" onkeyup="liveSearch()" class="form-control" placeholder="جستجو...">
        </div>
    </div>

    <!-- دکمه‌های پری ست -->
    <div class="preset-buttons">
        <?php
        if ($sec_names_result->num_rows > 0) {
            while($sec_row = $sec_names_result->fetch_assoc()) {
                echo "<button class='btn btn-primary' onclick=\"filterBySecName('{$sec_row['sec_name']}')\">{$sec_row['sec_name']}</button>";
            }
        }
        ?>
    </div>

    <table class="table table-bordered" id="filesTable">
        <thead class="thead-dark">
            <tr>
                <th>ردیف</th>
                <th>نام</th>
                <th>نام خانوادگی</th>
                <th>شماره ملی</th>
                <th>تلفن</th>
                <th>نوع درخواست</th>
                <th>وضعیت</th>
                <th>علت تعلیق</th>
                <th>نام دبیرخانه</th>
                <th>رفع تعلیق پرونده</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<tr>
                            <td></td> <!-- شماره‌گذاری با JavaScript انجام می‌شود -->
                            <td>{$row['operator_first_name']}</td>
                            <td>{$row['operator_last_name']}</td>
                            <td>{$row['national_code']}</td>
                            <td>{$row['phone_number']}</td>
                            <td>{$row['request_type']}</td>
                            <td>{$row['status']}</td>
                            <td>{$row['sus_reason']}</td>
                            <td>{$row['sec_name']}</td>
                            <td>
                                <form action='unsuspend.php' method='POST'>
                                    <input type='hidden' name='file_id' value='{$row['file_id']}'>
                                    <button type='submit' class='btn btn-success'>رفع تعلیق</button>
                                </form>
                            </td>
                          </tr>";
                }
            } else {
                echo "<tr><td colspan='10'>هیچ پرونده معلقی یافت نشد</td></tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<!-- دکمه استیکی برای بازگشت به داشبورد -->
<div class="sticky-btn">
    <a href="<?php echo $dashboard_url; ?>" class="btn btn-secondary">بازگشت به داشبورد</a>
</div>
</body>
</html>



<?php
$conn->close();
?>
