<?php
include 'db_connection.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $file_id = $_POST['file_id'];
    $user_id = $_SESSION['user_id']; // فرض می‌کنیم یوزر آی‌دی کاربر در جلسه ذخیره شده است

    // تابعی برای تبدیل تاریخ میلادی به هجری شمسی
    function gregorian_to_jalali($gy, $gm, $gd, $mod = '') {
        $g_d_m = array(0, 31, ($gy % 4 == 0 and $gy % 100 != 0 or $gy % 400 == 0) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
        if ($gy > 1600) {
            $jy = 979;
            $gy -= 1600;
        } else {
            $jy = 0;
            $gy -= 621;
        }
        $gy2 = ($gm > 2) ? ($gy + 1) : $gy;
        $days = (365 * $gy) + (int) (($gy2 + 3) / 4) - (int) (($gy2 + 99) / 100) + (int) (($gy2 + 399) / 400) - 80 + $gd + array_sum(array_slice($g_d_m, 0, $gm));
        $jy += 33 * (int) ($days / 12053);
        $days %= 12053;
        $jy += 4 * (int) ($days / 1461);
        $days %= 1461;
        $jy += (int) (($days - 1) / 365);
        if ($days > 365) {
            $days = ($days - 1) % 365;
        }
        if ($days < 186) {
            $jm = 1 + (int) ($days / 31);
            $jd = 1 + ($days % 31);
        } else {
            $jm = 7 + (int) (($days - 186) / 30);
            $jd = 1 + (($days - 186) % 30);
        }
        return ($mod == '') ? array($jy, $jm, $jd) : $jy . $mod . $jm . $mod . $jd;
    }

    // تاریخ و زمان کنونی
    $current_datetime = date('Y-m-d H:i:s');
    list($year, $month, $day) = explode('-', date('Y-m-d'));
    $unsus_date = implode('-', gregorian_to_jalali($year, $month, $day));

    // به روز رسانی وضعیت پرونده
    $sql = "UPDATE files SET status = 'جاری', stage_start_time = ?, unsus_user_id = ?, unsus_date = ? WHERE file_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('sisi', $current_datetime, $user_id, $unsus_date, $file_id);

    if ($stmt->execute()) {
        echo "وضعیت پرونده با موفقیت به روز رسانی شد.";
    } else {
        echo "خطا در به روز رسانی وضعیت پرونده: " . $stmt->error;
    }

    $stmt->close();
}

$conn->close();
?>
