<?php
require_once "db_connection.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id']);
    $step = intval($_POST['step']);
    $expert_name = trim($_POST['expert_name']);

    $fileField = "file" . $step;
    $expertField = "expert" . $step;

    if (!isset($_FILES['upload_file']) || $_FILES['upload_file']['error'] !== UPLOAD_ERR_OK) {
        http_response_code(400);
        echo "خطا در بارگذاری فایل";
        exit;
    }

    $uploadDir = 'k_uploads/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $originalName = basename($_FILES['upload_file']['name']);
    $extension = pathinfo($originalName, PATHINFO_EXTENSION);
    $allowedExtensions = ['pdf', 'jpg', 'jpeg', 'png', 'doc', 'docx', 'rar', 'zip'];
    if (!in_array(strtolower($extension), $allowedExtensions)) {
        http_response_code(415);
        echo "فرمت فایل مجاز نیست.";
        exit;
    }

    $uniqueName = uniqid("report_step{$step}_") . '.' . $extension;
    $destination = $uploadDir . $uniqueName;

    if (!move_uploaded_file($_FILES['upload_file']['tmp_name'], $destination)) {
        http_response_code(500);
        echo "بارگذاری فایل با شکست مواجه شد.";
        exit;
    }

    // ثبت فایل و نام کارشناس در دیتابیس
    $stmt = $conn->prepare("UPDATE karshenasan SET $fileField = ?, $expertField = ? WHERE id = ?");
    $stmt->bind_param("ssi", $uniqueName, $expert_name, $id);
    if ($stmt->execute()) {
        echo $uniqueName;
    } else {
        http_response_code(500);
        echo "ثبت در دیتابیس با شکست مواجه شد.";
    }
    $stmt->close();
    $conn->close();
}
