<?php
require_once "db_connection.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['jahad_file'])) {
    $id = intval($_POST['id']);
    $step = intval($_POST['step']);

    // نام فیلد در دیتابیس (مثلاً jahad1, jahad2, ...)
    $fieldName = "jahad" . $step;

    $uploadDir = "k_uploads/jahad";
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // ساخت نام فایل یکتا
    $originalName = basename($_FILES['jahad_file']['name']);
    $fileExt = pathinfo($originalName, PATHINFO_EXTENSION);
    $newFileName = "jahad_" . $id . "_step" . $step . "_" . time() . "." . $fileExt;

    $targetPath = $uploadDir . $newFileName;

    if (move_uploaded_file($_FILES['jahad_file']['tmp_name'], $targetPath)) {
        // ذخیره مسیر فایل در دیتابیس
        $stmt = $conn->prepare("UPDATE karshenasan SET $fieldName = ? WHERE id = ?");
        $stmt->bind_param("si", $targetPath, $id);
        $stmt->execute();
        $stmt->close();

        // خروجی برای نمایش لینک دانلود
        echo $newFileName;
    } else {
        http_response_code(500);
        echo "خطا در آپلود فایل";
    }
} else {
    http_response_code(400);
    echo "درخواست نامعتبر";
}
