<?php
session_start();

// بررسی اینکه آیا کاربر وارد شده و نقش وی admin است
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: admin_login.html");
    exit;
}

include('db_connection.php');

// دریافت نام کاربران و تعداد پرونده‌های جاری بر اساس مرحله
$users = [];

$sql = "SELECT u.user_id, u.first_name, u.last_name, f.stage_name, COUNT(f.file_id) AS count
        FROM files f 
        JOIN users u ON f.assigned_to = u.user_id 
        WHERE f.status = 'جاری'
        GROUP BY u.user_id, f.stage_name";
$result = $conn->query($sql);

while ($row = $result->fetch_assoc()) {
    $userId = $row['user_id'];
    if (!isset($users[$userId])) {
        $users[$userId] = [
            'name' => $row['first_name'] . ' ' . $row['last_name'],
            'stages' => []
        ];
    }
    $users[$userId]['stages'][$row['stage_name']] = $row['count'];
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>گزارش پرونده‌ها به تفکیک کاربر</title>
    <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Vazir', sans-serif;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .content {
            flex: 1;
        }
        .card {
            margin-bottom: 20px;
        }
        .chart-container {
            position: relative;
            height: 400px; /* تنظیم ارتفاع نمودار */
        }
        .user-cards {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }
        .user-card {
            flex: 1;
            min-width: 200px;
            max-width: 250px;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#">پنل مدیریتی سامانه رصد</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="#">خروج</a>
                </li>
            </ul>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="content">
            <h1>گزارش پرونده‌ها به تفکیک کاربر</h1>
            <div class="user-cards">
                <?php foreach ($users as $userId => $user) { ?>
                    <div class="card user-card">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo $user['name']; ?></h5>
                            <button class="btn btn-primary" onclick="showChart('<?php echo $userId; ?>')">نمایش نمودار</button>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <div id="charts-container">
                <!-- نمودارها اینجا نمایش داده می‌شوند -->
            </div>
        </div>
    </div>

    <script>
        const users = <?php echo json_encode($users); ?>;

        function showChart(userId) {
            const user = users[userId];
            const stages = Object.keys(user.stages);
            const counts = Object.values(user.stages);

            const chartContainer = document.getElementById('charts-container');
            chartContainer.innerHTML = `
                <div class="card">
                    <div class="card-header">
                        نمودار پرونده‌های جاری کاربر ${user.name} به تفکیک مرحله
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="userChart-${userId}"></canvas>
                        </div>
                    </div>
                </div>
            `;

            const ctx = document.getElementById(`userChart-${userId}`).getContext('2d');
            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: stages,
                    datasets: [{
                        label: 'تعداد پرونده‌ها',
                        data: counts,
                        backgroundColor: 'rgba(75, 192, 192, 0.2)',
                        borderColor: 'rgba(75, 192, 192, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        }
    </script>
</body>
</html>
